// npc.cpp ackmed@gotwalls.com
// npc info provided by Blackpower
#include "npc.h"

NPCSTRUCT allNPC[] = {
	{ // ACT 1 npcs (6)
		0,
		{0,0},
		ACT1,
		0x009b,
		"Warriv",
		"rogue encampment"
	},
	{
		0,
		{0,0},
		ACT1,
		0x0109,
		"Cain",
		"rogue encampment"
	},
	{
		0,
		{0,0},
		ACT1,
		0x009a,
		"Charsi",
		"rogue encampment"
	},
	{
		0,
		{0,0},
		ACT1,
		0x0093,
		"Gheed",
		"rogue encampment"
	},
	{
		0,
		{0,0},
		ACT1,
		0x0096,
		"Kashya",
		"rogue encampment"
	},
	{
		0,
		{0,0},
		ACT1,
		0x0094, 
		"Akara",
		"rogue encampment"
	},
	{ // act 2 npcs (10)
		0,
		{0,0},
		ACT2,
		0x00f4,
		"Cain",
		"lut gholein"
	},
	{
		0,
		{0,0},
		ACT2,
		0x00c7,
		"Elzix",
		"lut gholein"
	},
	{
		0,
		{0,0},
		ACT2,
		0x00c6,
		"Greiz",
		"lut gholein"
	},
	{
		0,
		{0,0},
		ACT2,
		0x00b1,
		"Drognan",
		"lut gholein"
	},
	{
		0,
		{0,0},
		ACT2,
		0x00ca,
		"Lysander",
		"lut gholein"
	},
	{
		0,
		{0,0},
		ACT2,
		0x00b2,
		"Fara",
		"lut gholein"
	},
	{
		0,
		{0,0},
		ACT2,
		0x00b0,
		"Atma",
		"lut gholein"
	},
	{
		0,
		{0,0},
		ACT2,
		0x00d2,
		"Meshif",
		"lut gholein"
	},
	{
		0,
		{0,0},
		ACT2,
		0x00af,
		"Warriv",
		"lut gholein"
	},
	{
		0,
		{0,0},
		ACT2,
		0x00c9,
		"Jerhyn",
		"lut gholein"
	},
	{ // act 3 npcs (6)
		0,
		{0,0},
		ACT3,
		0x00f5,
		"Cain",
		"kurast docks"
	},
	{
		0,
		{0,0},
		ACT3,
		0x00fe,
		"Alkor",
		"kurast docks"
	},
	{
		0,
		{0,0},
		ACT3,
		0x00fc,
		"Asheara",
		"kurast docks"
	},
	{
		0,
		{0,0},
		ACT3,
		0x00ff,
		"Ormus",
		"kurast docks"
	},
	{
		0,
		{0,0},
		ACT3,
		0x0801,
		"Meshif",
		"kurast docks"
	},
	{
		0,
		{0,0},
		ACT3,
		0x00fd,
		"Hratli",
		"kurast docks"
	},
	{ // act 4 (4)
		0,
		{0,0},
		ACT4,
		0x00f6,
		"Cain",
		"the pandemonium fortress"
	},
	{
		0,
		{0,0},
		ACT4,
		0x016f,
		"Tyrael",
		"the pandemonium fortress"
	},
	{
		0,
		{0,0},
		ACT4,
		0x0195,
		"Jamella",
		"the pandemonium fortress"
	},
	{
		0,
		{0,0},
		ACT4,
		0x0101,
		"Halbu",
		"the pandemonium fortress"
	},
	{ // act 5 (6)
		0,
		{0,0},
		ACT5,
		0x0208,
		"Cain",
		"harrogath"
	},
	{
		0,
		{0,0},
		ACT5,
		0x01ff,
		"Larzuk",
		"harrogath"
	},
	{
		0,
		{0,0},
		ACT5,
		0x0201,
		"Malah",
		"harrogath"
	},
	{
		0,
		{0,0},
		ACT5,
		0x0203,
		"Qual-Kehk",
		"harrogath"
	},
	{
		0,
		{0,0},
		ACT5,
		0x0202,
		"Nihlathak",
		"harrogath"
	},
	{
		0,
		{0,0},
		ACT5,
		0x0200,
		"Anya",
		"harrogath"
	}

};

void SetNPCLid(int actNum, char* npcName) {

	for(int i = 0;i < NPC_TOTAL;i++) {
		// check act number
		if(allNPC[i].actNum == actNum) {
			// compare names
			if(strcmpi(npcName,allNPC[i].name) == 0) {
				// match.  set lid
				npc = allNPC[i];

				sprintf(DebugBuffer,"NPC Set to %s",npc.name);
				server->GamePrintString(DebugBuffer);
				SetNPC = true;
				sprintf(DebugBuffer,"shopbot townwp %s",npc.townwp);
				server->GameCommandLine(DebugBuffer);
				return;
			}
		}
	}
	sprintf(DebugBuffer,"Unabled to locate '%s' in act%d",npcName,actNum);
	server->GamePrintString(DebugBuffer);
}

// print a list of npc's names at are avail for actNum
void ListNPC(int actNum) {
	for(int i = 0;i < NPC_TOTAL;i++) {
		if(allNPC[i].actNum == actNum) {
			server->GamePrintString(allNPC[i].name);
		}
	}
}